/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.autoconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.guerlab.smart.region.api.RegionApi;
import net.guerlab.smart.region.api.autoconfig.RegionApiLocalServiceAutoConfigure;
import net.guerlab.smart.region.api.feign.FeignRegionApi;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.smart.region.core.exception.RegionInvalidException;
import net.guerlab.smart.region.core.searchparams.RegionSearchParams;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={RegionApiLocalServiceAutoConfigure.class})
public class RegionApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={RegionApi.class})
    @ConditionalOnBean(value={FeignRegionApi.class})
    public RegionApi regionApiFeignWrapper(FeignRegionApi api) {
        return new RegionApiFeignWrapper(api);
    }

    private static class RegionApiFeignWrapper
    implements RegionApi {
        private FeignRegionApi api;

        @Override
        public RegionDTO findOne(Long areaId) {
            return Optional.ofNullable((RegionDTO)this.api.findOne(areaId).getData()).orElseThrow(RegionInvalidException::new);
        }

        @Override
        public ListObject<RegionDTO> findList(RegionSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((ListObject)this.api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<RegionDTO> findAll(RegionSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((List)this.api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        @Override
        public List<RegionDTO> tree() {
            return Optional.ofNullable((List)this.api.tree().getData()).orElse(Collections.emptyList());
        }

        @Override
        public List<RegionDTO> findDepthList(Long regionId) {
            return Optional.ofNullable((List)this.api.findDepthList(regionId).getData()).orElse(Collections.emptyList());
        }

        public RegionApiFeignWrapper(FeignRegionApi api) {
            this.api = api;
        }
    }
}

