package net.guerlab.smart.region.api;

import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.smart.region.core.searchparams.RegionSearchParams;
import net.guerlab.web.result.ListObject;

import java.util.List;

/**
 * 地区服务接口
 *
 * @author guer
 */
public interface RegionApi {

    /**
     * 根据地区id查询地区
     *
     * @param regionId
     *         地区id
     * @return 地区
     */
    RegionDTO findOne(Long regionId);

    /**
     * 根据搜索参数查询地区列表
     *
     * @param searchParams
     *         搜索参数
     * @return 地区列表
     */
    ListObject<RegionDTO> findList(RegionSearchParams searchParams);

    /**
     * 根据搜索参数查询地区列表
     *
     * @param searchParams
     *         搜索参数
     * @return 地区列表
     */
    List<RegionDTO> findAll(RegionSearchParams searchParams);

    /**
     * 根据搜索参数查询地区列表
     *
     * @return 地区树
     */
    List<RegionDTO> tree();

    /**
     * 获取深度列表
     *
     * @param regionId
     *         地区ID
     * @return 深度列表
     */
    List<RegionDTO> findDepthList(Long regionId);
}
