/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.feign.factory;

import feign.hystrix.FallbackFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.smart.region.api.feign.FeignStreetApi;
import net.guerlab.smart.region.core.domain.StreetDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignStreetApiFallbackFactory
implements FallbackFactory<FeignStreetApi> {
    public FeignStreetApi create(Throwable cause) {
        return new FeignStreetApiFallback(cause);
    }

    static class FeignStreetApiFallback
    implements FeignStreetApi {
        private static final Logger log = LoggerFactory.getLogger(FeignStreetApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<StreetDTO> findOne(Long streetId) {
            log.error("findOne fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<ListObject<StreetDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", this.cause);
            return new Fail("fallback", (Object)ListObject.empty());
        }

        @Override
        public Result<List<StreetDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        public FeignStreetApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

