/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.feign.factory;

import feign.hystrix.FallbackFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.smart.region.api.feign.FeignProvinceApi;
import net.guerlab.smart.region.core.domain.ProvinceDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignProvinceApiFallbackFactory
implements FallbackFactory<FeignProvinceApi> {
    public FeignProvinceApi create(Throwable cause) {
        return new FeignProvinceApiFallback(cause);
    }

    static class FeignProvinceApiFallback
    implements FeignProvinceApi {
        private static final Logger log = LoggerFactory.getLogger(FeignProvinceApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<ProvinceDTO> findOne(Long provinceId) {
            log.error("findOne fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<ListObject<ProvinceDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", this.cause);
            return new Fail("fallback", (Object)ListObject.empty());
        }

        @Override
        public Result<List<ProvinceDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        public FeignProvinceApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

