/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.feign.factory;

import feign.hystrix.FallbackFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.smart.region.api.feign.FeignCityApi;
import net.guerlab.smart.region.core.domain.CityDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignCityApiFallbackFactory
implements FallbackFactory<FeignCityApi> {
    public FeignCityApi create(Throwable cause) {
        return new FeignCityApiFallback(cause);
    }

    static class FeignCityApiFallback
    implements FeignCityApi {
        private static final Logger log = LoggerFactory.getLogger(FeignCityApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<CityDTO> findOne(Long cityId) {
            log.error("findOne fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<ListObject<CityDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", this.cause);
            return new Fail("fallback", (Object)ListObject.empty());
        }

        @Override
        public Result<List<CityDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        public FeignCityApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

