/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.feign.factory;

import feign.hystrix.FallbackFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.smart.region.api.feign.FeignAreaApi;
import net.guerlab.smart.region.core.domain.AreaDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignAreaApiFallbackFactory
implements FallbackFactory<FeignAreaApi> {
    public FeignAreaApi create(Throwable cause) {
        return new FeignAreaApiFallback(cause);
    }

    static class FeignAreaApiFallback
    implements FeignAreaApi {
        private static final Logger log = LoggerFactory.getLogger(FeignAreaApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<AreaDTO> findOne(Long areaId) {
            log.error("findOne fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<ListObject<AreaDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", this.cause);
            return new Fail("fallback", (Object)ListObject.empty());
        }

        @Override
        public Result<List<AreaDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        public FeignAreaApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

