/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.autoconfig;

import java.util.Collection;
import java.util.List;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.region.api.StreetApi;
import net.guerlab.smart.region.core.domain.StreetDTO;
import net.guerlab.smart.region.core.exception.StreetInvalidException;
import net.guerlab.smart.region.core.searchparams.StreetSearchParams;
import net.guerlab.smart.region.service.entity.Street;
import net.guerlab.smart.region.service.service.StreetService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class StreetApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={StreetService.class})
    public StreetApi streetApiLocalServiceWrapper(StreetService service) {
        return new StreetApiLocalServiceWrapper(service);
    }

    private static class StreetApiLocalServiceWrapper
    implements StreetApi {
        private StreetService service;

        @Override
        public StreetDTO findOne(Long areaId) {
            return (StreetDTO)((Street)this.service.selectByIdOptional((Object)areaId).orElseThrow(StreetInvalidException::new)).toDTO();
        }

        @Override
        public ListObject<StreetDTO> findList(StreetSearchParams searchParams) {
            return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
        }

        @Override
        public List<StreetDTO> findAll(StreetSearchParams searchParams) {
            return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
        }

        public StreetApiLocalServiceWrapper(StreetService service) {
            this.service = service;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.region.service.service.StreetService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

