/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.autoconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.guerlab.smart.region.api.StreetApi;
import net.guerlab.smart.region.api.autoconfig.StreetApiLocalServiceAutoConfigure;
import net.guerlab.smart.region.api.feign.FeignStreetApi;
import net.guerlab.smart.region.core.domain.StreetDTO;
import net.guerlab.smart.region.core.exception.StreetInvalidException;
import net.guerlab.smart.region.core.searchparams.StreetSearchParams;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={StreetApiLocalServiceAutoConfigure.class})
public class StreetApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={StreetApi.class})
    @ConditionalOnBean(value={FeignStreetApi.class})
    public StreetApi streetApiFeignWrapper(FeignStreetApi api) {
        return new StreetApiFeignWrapper(api);
    }

    private static class StreetApiFeignWrapper
    implements StreetApi {
        private FeignStreetApi api;

        @Override
        public StreetDTO findOne(Long areaId) {
            return Optional.ofNullable((StreetDTO)this.api.findOne(areaId).getData()).orElseThrow(StreetInvalidException::new);
        }

        @Override
        public ListObject<StreetDTO> findList(StreetSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((ListObject)this.api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<StreetDTO> findAll(StreetSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((List)this.api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        public StreetApiFeignWrapper(FeignStreetApi api) {
            this.api = api;
        }
    }
}

