/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.autoconfig;

import java.util.Collection;
import java.util.List;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.region.api.ProvinceApi;
import net.guerlab.smart.region.core.domain.ProvinceDTO;
import net.guerlab.smart.region.core.exception.ProvinceInvalidException;
import net.guerlab.smart.region.core.searchparams.ProvinceSearchParams;
import net.guerlab.smart.region.service.entity.Province;
import net.guerlab.smart.region.service.service.ProvinceService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class ProvinceApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={ProvinceService.class})
    public ProvinceApi provinceApiLocalServiceWrapper(ProvinceService service) {
        return new ProvinceApiLocalServiceWrapper(service);
    }

    private static class ProvinceApiLocalServiceWrapper
    implements ProvinceApi {
        private ProvinceService service;

        @Override
        public ProvinceDTO findOne(Long provinceId) {
            return (ProvinceDTO)((Province)this.service.selectByIdOptional((Object)provinceId).orElseThrow(ProvinceInvalidException::new)).toDTO();
        }

        @Override
        public ListObject<ProvinceDTO> findList(ProvinceSearchParams searchParams) {
            return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
        }

        @Override
        public List<ProvinceDTO> findAll(ProvinceSearchParams searchParams) {
            return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
        }

        public ProvinceApiLocalServiceWrapper(ProvinceService service) {
            this.service = service;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.region.service.service.ProvinceService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

