/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.autoconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.guerlab.smart.region.api.ProvinceApi;
import net.guerlab.smart.region.api.autoconfig.ProvinceApiLocalServiceAutoConfigure;
import net.guerlab.smart.region.api.feign.FeignProvinceApi;
import net.guerlab.smart.region.core.domain.ProvinceDTO;
import net.guerlab.smart.region.core.exception.ProvinceInvalidException;
import net.guerlab.smart.region.core.searchparams.ProvinceSearchParams;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={ProvinceApiLocalServiceAutoConfigure.class})
public class ProvinceApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={ProvinceApi.class})
    public ProvinceApi provinceApiFeignWrapper(FeignProvinceApi api) {
        return new ProvinceApiFeignWrapper(api);
    }

    private static class ProvinceApiFeignWrapper
    implements ProvinceApi {
        private FeignProvinceApi api;

        @Override
        public ProvinceDTO findOne(Long provinceId) {
            return Optional.ofNullable((ProvinceDTO)this.api.findOne(provinceId).getData()).orElseThrow(ProvinceInvalidException::new);
        }

        @Override
        public ListObject<ProvinceDTO> findList(ProvinceSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((ListObject)this.api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<ProvinceDTO> findAll(ProvinceSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((List)this.api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        public ProvinceApiFeignWrapper(FeignProvinceApi api) {
            this.api = api;
        }
    }
}

