/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.autoconfig;

import java.util.Collection;
import java.util.List;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.region.api.CityApi;
import net.guerlab.smart.region.core.domain.CityDTO;
import net.guerlab.smart.region.core.exception.CityInvalidException;
import net.guerlab.smart.region.core.searchparams.CitySearchParams;
import net.guerlab.smart.region.service.entity.City;
import net.guerlab.smart.region.service.service.CityService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class CityApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={CityService.class})
    public CityApi cityApiLocalServiceWrapper(CityService service) {
        return new CityApiLocalServiceWrapper(service);
    }

    private static class CityApiLocalServiceWrapper
    implements CityApi {
        private CityService service;

        @Override
        public CityDTO findOne(Long cityId) {
            return (CityDTO)((City)this.service.selectByIdOptional((Object)cityId).orElseThrow(CityInvalidException::new)).toDTO();
        }

        @Override
        public ListObject<CityDTO> findList(CitySearchParams searchParams) {
            return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
        }

        @Override
        public List<CityDTO> findAll(CitySearchParams searchParams) {
            return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
        }

        public CityApiLocalServiceWrapper(CityService service) {
            this.service = service;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.region.service.service.CityService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

