/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.autoconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.guerlab.smart.region.api.CityApi;
import net.guerlab.smart.region.api.autoconfig.CityApiLocalServiceAutoConfigure;
import net.guerlab.smart.region.api.feign.FeignCityApi;
import net.guerlab.smart.region.core.domain.CityDTO;
import net.guerlab.smart.region.core.exception.CityInvalidException;
import net.guerlab.smart.region.core.searchparams.CitySearchParams;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={CityApiLocalServiceAutoConfigure.class})
public class CityApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={CityApi.class})
    @ConditionalOnBean(value={FeignCityApi.class})
    public CityApi cityApiFeignWrapper(FeignCityApi api) {
        return new CityApiFeignWrapper(api);
    }

    private static class CityApiFeignWrapper
    implements CityApi {
        private FeignCityApi api;

        @Override
        public CityDTO findOne(Long cityId) {
            return Optional.ofNullable((CityDTO)this.api.findOne(cityId).getData()).orElseThrow(CityInvalidException::new);
        }

        @Override
        public ListObject<CityDTO> findList(CitySearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((ListObject)this.api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<CityDTO> findAll(CitySearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((List)this.api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        public CityApiFeignWrapper(FeignCityApi api) {
            this.api = api;
        }
    }
}

