/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.autoconfig;

import java.util.Collection;
import java.util.List;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.region.api.AreaApi;
import net.guerlab.smart.region.core.domain.AreaDTO;
import net.guerlab.smart.region.core.exception.AreaInvalidException;
import net.guerlab.smart.region.core.searchparams.AreaSearchParams;
import net.guerlab.smart.region.service.entity.Area;
import net.guerlab.smart.region.service.service.AreaService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class AreaApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={AreaService.class})
    public AreaApi areaApiLocalServiceWrapper(AreaService service) {
        return new AreaApiLocalServiceWrapper(service);
    }

    private static class AreaApiLocalServiceWrapper
    implements AreaApi {
        private AreaService service;

        @Override
        public AreaDTO findOne(Long areaId) {
            return (AreaDTO)((Area)this.service.selectByIdOptional((Object)areaId).orElseThrow(AreaInvalidException::new)).toDTO();
        }

        @Override
        public ListObject<AreaDTO> findList(AreaSearchParams searchParams) {
            return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
        }

        @Override
        public List<AreaDTO> findAll(AreaSearchParams searchParams) {
            return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
        }

        public AreaApiLocalServiceWrapper(AreaService service) {
            this.service = service;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.region.service.service.AreaService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

