/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.autoconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.guerlab.smart.region.api.AreaApi;
import net.guerlab.smart.region.api.autoconfig.AreaApiLocalServiceAutoConfigure;
import net.guerlab.smart.region.api.feign.FeignAreaApi;
import net.guerlab.smart.region.core.domain.AreaDTO;
import net.guerlab.smart.region.core.exception.AreaInvalidException;
import net.guerlab.smart.region.core.searchparams.AreaSearchParams;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={AreaApiLocalServiceAutoConfigure.class})
public class AreaApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={AreaApi.class})
    @ConditionalOnBean(value={FeignAreaApi.class})
    public AreaApi areaApiFeignWrapper(FeignAreaApi api) {
        return new AreaApiFeignWrapper(api);
    }

    private static class AreaApiFeignWrapper
    implements AreaApi {
        private FeignAreaApi api;

        @Override
        public AreaDTO findOne(Long areaId) {
            return Optional.ofNullable((AreaDTO)this.api.findOne(areaId).getData()).orElseThrow(AreaInvalidException::new);
        }

        @Override
        public ListObject<AreaDTO> findList(AreaSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((ListObject)this.api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<AreaDTO> findAll(AreaSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((List)this.api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        public AreaApiFeignWrapper(FeignAreaApi api) {
            this.api = api;
        }
    }
}

