package net.guerlab.smart.region.api.feign.factory;

import feign.hystrix.FallbackFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.region.api.feign.FeignStreetApi;
import net.guerlab.smart.region.core.domain.StreetDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 街道服务接口快速失败类构建工厂
 *
 * @author guer
 */
public class FeignStreetApiFallbackFactory implements FallbackFactory<FeignStreetApi> {

    @Override
    public FeignStreetApi create(Throwable cause) {
        return new FeignStreetApiFallback(cause);
    }

    /**
     * 街道服务接口快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignStreetApiFallback implements FeignStreetApi {

        private final Throwable cause;

        @Override
        public Result<StreetDTO> findOne(Long streetId) {
            log.error("findOne fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<ListObject<StreetDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", cause);
            return new Fail<>("fallback", ListObject.empty());
        }

        @Override
        public Result<List<StreetDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", cause);
            return new Fail<>("fallback", Collections.emptyList());
        }
    }

}
