package net.guerlab.smart.region.api.feign.factory;

import feign.hystrix.FallbackFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.region.api.feign.FeignProvinceApi;
import net.guerlab.smart.region.core.domain.ProvinceDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 省服务接口快速失败类构建工厂
 *
 * @author guer
 */
public class FeignProvinceApiFallbackFactory implements FallbackFactory<FeignProvinceApi> {

    @Override
    public FeignProvinceApi create(Throwable cause) {
        return new FeignProvinceApiFallback(cause);
    }

    /**
     * 省服务接口快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignProvinceApiFallback implements FeignProvinceApi {

        private final Throwable cause;

        @Override
        public Result<ProvinceDTO> findOne(Long provinceId) {
            log.error("findOne fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<ListObject<ProvinceDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", cause);
            return new Fail<>("fallback", ListObject.empty());
        }

        @Override
        public Result<List<ProvinceDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", cause);
            return new Fail<>("fallback", Collections.emptyList());
        }
    }

}
