package net.guerlab.smart.region.api.feign.factory;

import feign.hystrix.FallbackFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.region.api.feign.FeignCityApi;
import net.guerlab.smart.region.core.domain.CityDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 市服务接口快速失败类构建工厂
 *
 * @author guer
 */
public class FeignCityApiFallbackFactory implements FallbackFactory<FeignCityApi> {

    @Override
    public FeignCityApi create(Throwable cause) {
        return new FeignCityApiFallback(cause);
    }

    /**
     * 市服务接口快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignCityApiFallback implements FeignCityApi {

        private final Throwable cause;

        @Override
        public Result<CityDTO> findOne(Long cityId) {
            log.error("findOne fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<ListObject<CityDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", cause);
            return new Fail<>("fallback", ListObject.empty());
        }

        @Override
        public Result<List<CityDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", cause);
            return new Fail<>("fallback", Collections.emptyList());
        }
    }

}
