package net.guerlab.smart.region.api.feign.factory;

import feign.hystrix.FallbackFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.region.api.feign.FeignAreaApi;
import net.guerlab.smart.region.core.domain.AreaDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 区服务接口快速失败类构建工厂
 *
 * @author guer
 */
public class FeignAreaApiFallbackFactory implements FallbackFactory<FeignAreaApi> {

    @Override
    public FeignAreaApi create(Throwable cause) {
        return new FeignAreaApiFallback(cause);
    }

    /**
     * 区服务接口快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignAreaApiFallback implements FeignAreaApi {

        private final Throwable cause;

        @Override
        public Result<AreaDTO> findOne(Long areaId) {
            log.error("findOne fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<ListObject<AreaDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", cause);
            return new Fail<>("fallback", ListObject.empty());
        }

        @Override
        public Result<List<AreaDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", cause);
            return new Fail<>("fallback", Collections.emptyList());
        }
    }

}
