package net.guerlab.smart.region.api.feign;

import net.guerlab.smart.region.api.feign.factory.FeignStreetApiFallbackFactory;
import net.guerlab.smart.region.core.domain.StreetDTO;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * 街道服务接口
 *
 * @author guer
 */
@FeignClient(name = "region-internal/inside/street", fallbackFactory = FeignStreetApiFallbackFactory.class)
public interface FeignStreetApi {

    /**
     * 根据街道id查询街道
     *
     * @param streetId
     *         街道id
     * @return 街道
     */
    @PostMapping("/{streetId}")
    Result<StreetDTO> findOne(@PathVariable("streetId") Long streetId);

    /**
     * 根据搜索参数查询街道列表
     *
     * @param searchParams
     *         搜索参数
     * @return 街道列表
     */
    @PostMapping
    Result<ListObject<StreetDTO>> findList(@RequestBody Map<String, Object> searchParams);

    /**
     * 根据搜索参数查询街道列表
     *
     * @param searchParams
     *         搜索参数
     * @return 街道列表
     */
    @PostMapping("/all")
    Result<List<StreetDTO>> findAll(@RequestBody Map<String, Object> searchParams);
}
