package net.guerlab.smart.region.api.feign;

import net.guerlab.smart.region.api.feign.factory.FeignProvinceApiFallbackFactory;
import net.guerlab.smart.region.core.domain.ProvinceDTO;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * 省服务接口
 *
 * @author guer
 */
@FeignClient(name = "region-internal/inside/province", fallbackFactory = FeignProvinceApiFallbackFactory.class)
public interface FeignProvinceApi {

    /**
     * 根据省id查询省
     *
     * @param provinceId
     *         省id
     * @return 省
     */
    @PostMapping("/{provinceId}")
    Result<ProvinceDTO> findOne(@PathVariable("provinceId") Long provinceId);

    /**
     * 根据搜索参数查询省列表
     *
     * @param searchParams
     *         搜索参数
     * @return 省列表
     */
    @PostMapping
    Result<ListObject<ProvinceDTO>> findList(@RequestBody Map<String, Object> searchParams);

    /**
     * 根据搜索参数查询省列表
     *
     * @param searchParams
     *         搜索参数
     * @return 省列表
     */
    @PostMapping("/all")
    Result<List<ProvinceDTO>> findAll(@RequestBody Map<String, Object> searchParams);
}
