package net.guerlab.smart.region.api.feign;

import net.guerlab.smart.region.api.feign.factory.FeignCityApiFallbackFactory;
import net.guerlab.smart.region.core.domain.CityDTO;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * 市服务接口
 *
 * @author guer
 */
@FeignClient(name = "region-internal/inside/city", fallbackFactory = FeignCityApiFallbackFactory.class)
public interface FeignCityApi {

    /**
     * 根据市id查询市
     *
     * @param cityId
     *         市id
     * @return 市
     */
    @PostMapping("/{cityId}")
    Result<CityDTO> findOne(@PathVariable("cityId") Long cityId);

    /**
     * 根据搜索参数查询市列表
     *
     * @param searchParams
     *         搜索参数
     * @return 市列表
     */
    @PostMapping
    Result<ListObject<CityDTO>> findList(@RequestBody Map<String, Object> searchParams);

    /**
     * 根据搜索参数查询市列表
     *
     * @param searchParams
     *         搜索参数
     * @return 市列表
     */
    @PostMapping("/all")
    Result<List<CityDTO>> findAll(@RequestBody Map<String, Object> searchParams);
}
