package net.guerlab.smart.region.api.feign;

import net.guerlab.smart.region.api.feign.factory.FeignAreaApiFallbackFactory;
import net.guerlab.smart.region.core.domain.AreaDTO;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * 区服务接口
 *
 * @author guer
 */
@FeignClient(name = "region-internal/inside/area", fallbackFactory = FeignAreaApiFallbackFactory.class)
public interface FeignAreaApi {

    /**
     * 根据区id查询区
     *
     * @param areaId
     *         区id
     * @return 区
     */
    @PostMapping("/{areaId}")
    Result<AreaDTO> findOne(@PathVariable("areaId") Long areaId);

    /**
     * 根据搜索参数查询区列表
     *
     * @param searchParams
     *         搜索参数
     * @return 区列表
     */
    @PostMapping
    Result<ListObject<AreaDTO>> findList(@RequestBody Map<String, Object> searchParams);

    /**
     * 根据搜索参数查询区列表
     *
     * @param searchParams
     *         搜索参数
     * @return 区列表
     */
    @PostMapping("/all")
    Result<List<AreaDTO>> findAll(@RequestBody Map<String, Object> searchParams);
}
