package net.guerlab.smart.region.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.region.api.StreetApi;
import net.guerlab.smart.region.core.domain.StreetDTO;
import net.guerlab.smart.region.core.exception.StreetInvalidException;
import net.guerlab.smart.region.core.searchparams.StreetSearchParams;
import net.guerlab.smart.region.service.service.StreetService;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.*;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

import java.util.List;

/**
 * @author guer
 */
@Configuration
@Conditional(StreetApiLocalServiceAutoConfigure.WrapperCondition.class)
public class StreetApiLocalServiceAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnBean(StreetService.class)
    public StreetApi streetApiLocalServiceWrapper(StreetService service) {
        return new StreetApiLocalServiceWrapper(service);
    }

    @SuppressWarnings("WeakerAccess")
    static class WrapperCondition implements Condition {

        @Override
        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader()
                        .loadClass("net.guerlab.smart.region.service.service.StreetService") != null;
            } catch (Exception e) {
                return false;
            }
        }
    }

    @AllArgsConstructor
    private static class StreetApiLocalServiceWrapper implements StreetApi {

        private StreetService service;

        @Override
        public StreetDTO findOne(Long areaId) {
            return service.selectByIdOptional(areaId).orElseThrow(StreetInvalidException::new).toDTO();
        }

        @Override
        public ListObject<StreetDTO> findList(StreetSearchParams searchParams) {
            return BeanConvertUtils.toListObject(service.selectPage(searchParams));
        }

        @Override
        public List<StreetDTO> findAll(StreetSearchParams searchParams) {
            return BeanConvertUtils.toList(service.selectAll(searchParams));
        }
    }

}
