package net.guerlab.smart.region.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.smart.region.api.StreetApi;
import net.guerlab.smart.region.api.feign.FeignStreetApi;
import net.guerlab.smart.region.core.domain.StreetDTO;
import net.guerlab.smart.region.core.exception.StreetInvalidException;
import net.guerlab.smart.region.core.searchparams.StreetSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.*;

/**
 * @author guer
 */
@Configuration
@AutoConfigureAfter(StreetApiLocalServiceAutoConfigure.class)
public class StreetApiFeignAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnMissingBean(StreetApi.class)
    @ConditionalOnBean(FeignStreetApi.class)
    public StreetApi streetApiFeignWrapper(FeignStreetApi api) {
        return new StreetApiFeignWrapper(api);
    }

    @AllArgsConstructor
    private static class StreetApiFeignWrapper implements StreetApi {

        private FeignStreetApi api;

        @Override
        public StreetDTO findOne(Long areaId) {
            return Optional.ofNullable(api.findOne(areaId).getData()).orElseThrow(StreetInvalidException::new);
        }

        @Override
        public ListObject<StreetDTO> findList(StreetSearchParams searchParams) {
            Map<String, Object> params = new HashMap<>(8);
            SearchParamsUtils.handler(searchParams, params);
            return Optional.ofNullable(api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<StreetDTO> findAll(StreetSearchParams searchParams) {
            Map<String, Object> params = new HashMap<>(8);
            SearchParamsUtils.handler(searchParams, params);
            return Optional.ofNullable(api.findAll(params).getData()).orElse(Collections.emptyList());
        }
    }

}
