package net.guerlab.smart.region.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.region.api.ProvinceApi;
import net.guerlab.smart.region.core.domain.ProvinceDTO;
import net.guerlab.smart.region.core.exception.ProvinceInvalidException;
import net.guerlab.smart.region.core.searchparams.ProvinceSearchParams;
import net.guerlab.smart.region.service.service.ProvinceService;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.*;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

import java.util.List;

/**
 * @author guer
 */
@Configuration
@Conditional(ProvinceApiLocalServiceAutoConfigure.WrapperCondition.class)
public class ProvinceApiLocalServiceAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnBean(ProvinceService.class)
    public ProvinceApi provinceApiLocalServiceWrapper(ProvinceService service) {
        return new ProvinceApiLocalServiceWrapper(service);
    }

    @SuppressWarnings("WeakerAccess")
    static class WrapperCondition implements Condition {

        @Override
        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader()
                        .loadClass("net.guerlab.smart.region.service.service.ProvinceService") != null;
            } catch (Exception e) {
                return false;
            }
        }
    }

    @AllArgsConstructor
    private static class ProvinceApiLocalServiceWrapper implements ProvinceApi {

        private ProvinceService service;

        @Override
        public ProvinceDTO findOne(Long provinceId) {
            return service.selectByIdOptional(provinceId).orElseThrow(ProvinceInvalidException::new).toDTO();
        }

        @Override
        public ListObject<ProvinceDTO> findList(ProvinceSearchParams searchParams) {
            return BeanConvertUtils.toListObject(service.selectPage(searchParams));
        }

        @Override
        public List<ProvinceDTO> findAll(ProvinceSearchParams searchParams) {
            return BeanConvertUtils.toList(service.selectAll(searchParams));
        }
    }

}
