package net.guerlab.smart.region.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.smart.region.api.ProvinceApi;
import net.guerlab.smart.region.api.feign.FeignProvinceApi;
import net.guerlab.smart.region.core.domain.ProvinceDTO;
import net.guerlab.smart.region.core.exception.ProvinceInvalidException;
import net.guerlab.smart.region.core.searchparams.ProvinceSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.*;

/**
 * @author guer
 */
@Configuration
@AutoConfigureAfter(ProvinceApiLocalServiceAutoConfigure.class)
public class ProvinceApiFeignAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnMissingBean(ProvinceApi.class)
    public ProvinceApi provinceApiFeignWrapper(FeignProvinceApi api) {
        return new ProvinceApiFeignWrapper(api);
    }

    @AllArgsConstructor
    private static class ProvinceApiFeignWrapper implements ProvinceApi {

        private FeignProvinceApi api;

        @Override
        public ProvinceDTO findOne(Long provinceId) {
            return Optional.ofNullable(api.findOne(provinceId).getData()).orElseThrow(ProvinceInvalidException::new);
        }

        @Override
        public ListObject<ProvinceDTO> findList(ProvinceSearchParams searchParams) {
            Map<String, Object> params = new HashMap<>(8);
            SearchParamsUtils.handler(searchParams, params);
            return Optional.ofNullable(api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<ProvinceDTO> findAll(ProvinceSearchParams searchParams) {
            Map<String, Object> params = new HashMap<>(8);
            SearchParamsUtils.handler(searchParams, params);
            return Optional.ofNullable(api.findAll(params).getData()).orElse(Collections.emptyList());
        }
    }

}
