package net.guerlab.smart.region.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.region.api.CityApi;
import net.guerlab.smart.region.core.domain.CityDTO;
import net.guerlab.smart.region.core.exception.CityInvalidException;
import net.guerlab.smart.region.core.searchparams.CitySearchParams;
import net.guerlab.smart.region.service.service.CityService;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.*;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

import java.util.List;

/**
 * @author guer
 */
@Configuration
@Conditional(CityApiLocalServiceAutoConfigure.WrapperCondition.class)
public class CityApiLocalServiceAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnBean(CityService.class)
    public CityApi cityApiLocalServiceWrapper(CityService service) {
        return new CityApiLocalServiceWrapper(service);
    }

    @SuppressWarnings("WeakerAccess")
    static class WrapperCondition implements Condition {

        @Override
        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader()
                        .loadClass("net.guerlab.smart.region.service.service.CityService") != null;
            } catch (Exception e) {
                return false;
            }
        }
    }

    @AllArgsConstructor
    private static class CityApiLocalServiceWrapper implements CityApi {

        private CityService service;

        @Override
        public CityDTO findOne(Long cityId) {
            return service.selectByIdOptional(cityId).orElseThrow(CityInvalidException::new).toDTO();
        }

        @Override
        public ListObject<CityDTO> findList(CitySearchParams searchParams) {
            return BeanConvertUtils.toListObject(service.selectPage(searchParams));
        }

        @Override
        public List<CityDTO> findAll(CitySearchParams searchParams) {
            return BeanConvertUtils.toList(service.selectAll(searchParams));
        }
    }

}
