package net.guerlab.smart.region.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.smart.region.api.CityApi;
import net.guerlab.smart.region.api.feign.FeignCityApi;
import net.guerlab.smart.region.core.domain.CityDTO;
import net.guerlab.smart.region.core.exception.CityInvalidException;
import net.guerlab.smart.region.core.searchparams.CitySearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.*;

/**
 * @author guer
 */
@Configuration
@AutoConfigureAfter(CityApiLocalServiceAutoConfigure.class)
public class CityApiFeignAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnMissingBean(CityApi.class)
    @ConditionalOnBean(FeignCityApi.class)
    public CityApi cityApiFeignWrapper(FeignCityApi api) {
        return new CityApiFeignWrapper(api);
    }

    @AllArgsConstructor
    private static class CityApiFeignWrapper implements CityApi {

        private FeignCityApi api;

        @Override
        public CityDTO findOne(Long cityId) {
            return Optional.ofNullable(api.findOne(cityId).getData()).orElseThrow(CityInvalidException::new);
        }

        @Override
        public ListObject<CityDTO> findList(CitySearchParams searchParams) {
            Map<String, Object> params = new HashMap<>(8);
            SearchParamsUtils.handler(searchParams, params);
            return Optional.ofNullable(api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<CityDTO> findAll(CitySearchParams searchParams) {
            Map<String, Object> params = new HashMap<>(8);
            SearchParamsUtils.handler(searchParams, params);
            return Optional.ofNullable(api.findAll(params).getData()).orElse(Collections.emptyList());
        }
    }

}
