package net.guerlab.smart.region.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.smart.region.api.AreaApi;
import net.guerlab.smart.region.api.feign.FeignAreaApi;
import net.guerlab.smart.region.core.domain.AreaDTO;
import net.guerlab.smart.region.core.exception.AreaInvalidException;
import net.guerlab.smart.region.core.searchparams.AreaSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.*;

/**
 * @author guer
 */
@Configuration
@AutoConfigureAfter(AreaApiLocalServiceAutoConfigure.class)
public class AreaApiFeignAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnMissingBean(AreaApi.class)
    @ConditionalOnBean(FeignAreaApi.class)
    public AreaApi areaApiFeignWrapper(FeignAreaApi api) {
        return new AreaApiFeignWrapper(api);
    }

    @AllArgsConstructor
    private static class AreaApiFeignWrapper implements AreaApi {

        private FeignAreaApi api;

        @Override
        public AreaDTO findOne(Long areaId) {
            return Optional.ofNullable(api.findOne(areaId).getData()).orElseThrow(AreaInvalidException::new);
        }

        @Override
        public ListObject<AreaDTO> findList(AreaSearchParams searchParams) {
            Map<String, Object> params = new HashMap<>(8);
            SearchParamsUtils.handler(searchParams, params);
            return Optional.ofNullable(api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<AreaDTO> findAll(AreaSearchParams searchParams) {
            Map<String, Object> params = new HashMap<>(8);
            SearchParamsUtils.handler(searchParams, params);
            return Optional.ofNullable(api.findAll(params).getData()).orElse(Collections.emptyList());
        }
    }

}
