package net.guerlab.smart.region.api;

import net.guerlab.smart.region.core.domain.StreetDTO;
import net.guerlab.smart.region.core.searchparams.StreetSearchParams;
import net.guerlab.web.result.ListObject;

import java.util.List;

/**
 * 街道服务接口
 *
 * @author guer
 */
public interface StreetApi {

    /**
     * 根据街道id查询街道
     *
     * @param areaId
     *         街道id
     * @return 街道
     */
    StreetDTO findOne(Long areaId);

    /**
     * 根据搜索参数查询街道列表
     *
     * @param searchParams
     *         搜索参数
     * @return 街道列表
     */
    ListObject<StreetDTO> findList(StreetSearchParams searchParams);

    /**
     * 根据搜索参数查询街道列表
     *
     * @param searchParams
     *         搜索参数
     * @return 街道列表
     */
    List<StreetDTO> findAll(StreetSearchParams searchParams);
}
