package net.guerlab.smart.region.api;

import net.guerlab.smart.region.core.domain.ProvinceDTO;
import net.guerlab.smart.region.core.searchparams.ProvinceSearchParams;
import net.guerlab.web.result.ListObject;

import java.util.List;

/**
 * 省服务接口
 *
 * @author guer
 */
public interface ProvinceApi {

    /**
     * 根据省id查询省
     *
     * @param provinceId
     *         省id
     * @return 省
     */
    ProvinceDTO findOne(Long provinceId);

    /**
     * 根据搜索参数查询省列表
     *
     * @param searchParams
     *         搜索参数
     * @return 省列表
     */
    ListObject<ProvinceDTO> findList(ProvinceSearchParams searchParams);

    /**
     * 根据搜索参数查询省列表
     *
     * @param searchParams
     *         搜索参数
     * @return 省列表
     */
    List<ProvinceDTO> findAll(ProvinceSearchParams searchParams);
}
