package net.guerlab.smart.region.api;

import net.guerlab.smart.region.core.domain.CityDTO;
import net.guerlab.smart.region.core.searchparams.CitySearchParams;
import net.guerlab.web.result.ListObject;

import java.util.List;

/**
 * 市服务接口
 *
 * @author guer
 */
public interface CityApi {

    /**
     * 根据市id查询市
     *
     * @param cityId
     *         市id
     * @return 市
     */
    CityDTO findOne(Long cityId);

    /**
     * 根据搜索参数查询市列表
     *
     * @param searchParams
     *         搜索参数
     * @return 市列表
     */
    ListObject<CityDTO> findList(CitySearchParams searchParams);

    /**
     * 根据搜索参数查询市列表
     *
     * @param searchParams
     *         搜索参数
     * @return 市列表
     */
    List<CityDTO> findAll(CitySearchParams searchParams);
}
