package net.guerlab.smart.region.api;

import net.guerlab.smart.region.core.domain.AreaDTO;
import net.guerlab.smart.region.core.searchparams.AreaSearchParams;
import net.guerlab.web.result.ListObject;

import java.util.List;

/**
 * 区服务接口
 *
 * @author guer
 */
public interface AreaApi {

    /**
     * 根据区id查询区
     *
     * @param areaId
     *         区id
     * @return 区
     */
    AreaDTO findOne(Long areaId);

    /**
     * 根据搜索参数查询区列表
     *
     * @param searchParams
     *         搜索参数
     * @return 区列表
     */
    ListObject<AreaDTO> findList(AreaSearchParams searchParams);

    /**
     * 根据搜索参数查询区列表
     *
     * @param searchParams
     *         搜索参数
     * @return 区列表
     */
    List<AreaDTO> findAll(AreaSearchParams searchParams);
}
