/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.stream.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.spring.commons.util.SpringApplicationContextUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.MessageBuilder;

public class MessageUtils {
    private static final String ORANGE_APP_NAME = "orange-app-name";

    private MessageUtils() {
    }

    public static <T> T read(Message<String> message, Class<T> clazz) {
        String payload = (String)message.getPayload();
        if (StringUtils.isBlank((CharSequence)payload)) {
            return null;
        }
        try {
            return (T)MessageUtils.getMapper().readValue(payload, clazz);
        }
        catch (Exception e) {
            throw new ApplicationException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static ObjectMapper getMapper() {
        return (ObjectMapper)SpringApplicationContextUtil.getContext().getBean(ObjectMapper.class);
    }

    public static boolean orangeAppNameSame(Message<?> message, String appName) {
        return Objects.equals(MessageUtils.toString(message.getHeaders().get((Object)ORANGE_APP_NAME)), appName);
    }

    public static boolean orangeAppNameSame(Message<?> message) {
        return MessageUtils.orangeAppNameSame(message, MessageUtils.getApplicationName());
    }

    public static String getAppName(Message<?> message) {
        return MessageUtils.toString(message.getHeaders().get((Object)ORANGE_APP_NAME));
    }

    private static String toString(Object value) {
        return value == null ? "" : value.toString();
    }

    public static boolean send(MessageChannel channel, MessageBuilder<?> builder) {
        builder.setHeader(ORANGE_APP_NAME, (Object)MessageUtils.getApplicationName());
        return channel.send(builder.build());
    }

    public static boolean send(MessageChannel channel, MessageBuilder<?> builder, long timeout) {
        builder.setHeader(ORANGE_APP_NAME, (Object)MessageUtils.getApplicationName());
        return channel.send(builder.build(), timeout);
    }

    public static <T> boolean send(MessageChannel channel, T message) {
        return MessageUtils.send(channel, MessageUtils.toBuilder(message));
    }

    public static <T> boolean send(MessageChannel channel, T message, long timeout) {
        return MessageUtils.send(channel, MessageUtils.toBuilder(message), timeout);
    }

    private static <T> MessageBuilder<String> toBuilder(T message) {
        try {
            return MessageBuilder.withPayload((Object)MessageUtils.getMapper().writeValueAsString(message));
        }
        catch (Exception e) {
            throw new ApplicationException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static Environment getEnvironment() {
        return SpringApplicationContextUtil.getContext().getEnvironment();
    }

    private static String getApplicationName() {
        return MessageUtils.getEnvironment().getProperty("spring.application.name");
    }
}

