/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.basic.gateway.vc;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.guerlab.smart.platform.basic.gateway.vc.Version;
import net.guerlab.smart.platform.basic.gateway.vc.VersionControlProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.gateway.config.LoadBalancerProperties;
import org.springframework.cloud.gateway.filter.LoadBalancerClientFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;

public class VersionControlFilter
extends LoadBalancerClientFilter {
    private DiscoveryClient discoveryClient;
    private VersionControlProperties properties;

    public VersionControlFilter(LoadBalancerClient loadBalancer, LoadBalancerProperties properties) {
        super(loadBalancer, properties);
    }

    protected ServiceInstance choose(ServerWebExchange exchange) {
        String requestKey = StringUtils.trimToNull((String)this.properties.getRequestKey());
        String metadataKey = StringUtils.trimToNull((String)this.properties.getMetadataKey());
        if (requestKey == null || metadataKey == null) {
            return super.choose(exchange);
        }
        Version requestVersion = this.parseVersion(requestKey, exchange.getRequest());
        if (requestVersion == null) {
            return super.choose(exchange);
        }
        URI uri = (URI)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        if (uri == null) {
            return super.choose(exchange);
        }
        String instancesId = uri.getHost();
        List instances = this.discoveryClient.getInstances(instancesId);
        if (instances == null || instances.isEmpty()) {
            return super.choose(exchange);
        }
        ArrayList hasNotVersions = new ArrayList(instances.size());
        ArrayList equalsVersions = new ArrayList(instances.size());
        ArrayList matchVersions = new ArrayList(instances.size());
        instances.forEach(instance -> {
            Version version = Version.parse((String)((String)instance.getMetadata().get(metadataKey)));
            if (version == null) {
                hasNotVersions.add(instance);
            } else if (version.equals((Object)requestVersion)) {
                equalsVersions.add(instance);
            } else if (version.match(requestVersion)) {
                matchVersions.add(instance);
            }
        });
        if (!matchVersions.isEmpty()) {
            return this.choose0(matchVersions);
        }
        if (!equalsVersions.isEmpty()) {
            return this.choose0(equalsVersions);
        }
        if (!hasNotVersions.isEmpty()) {
            return this.choose0(hasNotVersions);
        }
        return null;
    }

    private ServiceInstance choose0(List<ServiceInstance> instanceList) {
        return instanceList.get(RandomUtils.nextInt((int)0, (int)instanceList.size()));
    }

    private Version parseVersion(String requestKey, ServerHttpRequest request) {
        String versionString = StringUtils.trimToNull((String)request.getHeaders().getFirst(requestKey));
        if (versionString == null) {
            versionString = StringUtils.trimToNull((String)((String)request.getQueryParams().getFirst((Object)requestKey)));
        }
        return Version.parse((String)versionString, (boolean)false);
    }

    @Autowired
    public void setDiscoveryClient(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    @Autowired
    public void setProperties(VersionControlProperties properties) {
        this.properties = properties;
    }
}

