/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.basic.gateway.vc;

import java.util.Arrays;
import java.util.Objects;
import net.guerlab.smart.platform.basic.gateway.vc.Version;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class Version
implements Comparable<Version> {
    private static final String X = "x";
    private VersionMatchType matchType;
    private String major;
    private String minor;
    private String revision;
    private String ext;

    private Version() {
    }

    public static Version parse(String string) {
        return Version.parse((String)string, (boolean)true);
    }

    public static Version parse(String string, boolean parseMatchType) {
        if (string == null) {
            return null;
        }
        Version version = new Version();
        version.matchType = VersionMatchType.EQUALS;
        for (VersionMatchType matchType : VersionMatchType.values()) {
            if (matchType.symbol == null || !string.endsWith(matchType.symbol)) continue;
            if (parseMatchType) {
                version.matchType = matchType;
            }
            string = string.substring(0, string.length() - 1);
            break;
        }
        String[] strings = string.split("\\.");
        try {
            if (strings.length >= 1) {
                version.major = Version.parseVal((String)strings[0]);
            }
            if (strings.length >= 2) {
                version.minor = Version.parseVal((String)strings[1]);
            }
            if (strings.length >= 3) {
                version.revision = Version.parseVal((String)strings[2]);
            }
            if (strings.length >= 4) {
                version.ext = StringUtils.join((Object[])Arrays.copyOfRange(strings, 3, strings.length), (String)".");
            }
            return version;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    private static String parseVal(String val) {
        return "x".equalsIgnoreCase(val) ? "x" : String.valueOf(Integer.parseInt(val));
    }

    private static boolean valNotMatch(String v1, String v2, VersionMatchType matchType) {
        if ("x".equalsIgnoreCase(v1) || "x".equalsIgnoreCase(v2)) {
            return false;
        }
        if (matchType == VersionMatchType.UP) {
            return Integer.parseInt(v1) < Integer.parseInt(v2);
        }
        if (matchType == VersionMatchType.DOWN) {
            return Integer.parseInt(v1) > Integer.parseInt(v2);
        }
        return !Objects.equals(v1, v2);
    }

    private static Integer compareTo0(String v1, String v2) {
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return 1;
        }
        if (v2 == null) {
            return -1;
        }
        if (!Objects.equals(v1, v2)) {
            return v1.compareTo(v2);
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Version[");
        builder.append(this.major == null ? "unknow" : this.major);
        if (this.minor != null) {
            builder.append(".");
            builder.append(this.minor);
            if (this.revision != null) {
                builder.append(".");
                builder.append(this.revision);
                if (this.ext != null) {
                    builder.append(".");
                    builder.append(this.ext);
                }
            }
        }
        return builder.append(this.matchType.display).append("]").toString();
    }

    @Override
    public int compareTo(Version o) {
        if (o == null) {
            return 1;
        }
        Integer majorCompareTo = Version.compareTo0((String)o.major, (String)this.major);
        if (majorCompareTo != null) {
            return majorCompareTo;
        }
        Integer minorCompareTo = Version.compareTo0((String)o.minor, (String)this.minor);
        if (minorCompareTo != null) {
            return minorCompareTo;
        }
        Integer revisionCompareTo = Version.compareTo0((String)o.revision, (String)this.revision);
        if (revisionCompareTo != null) {
            return revisionCompareTo;
        }
        if (o.ext == null && this.ext == null) {
            return 0;
        }
        if (o.ext == null) {
            return 1;
        }
        if (this.ext == null) {
            return -1;
        }
        return this.ext.compareTo(o.ext);
    }

    public boolean match(Version o) {
        if (o == null) {
            return false;
        }
        if (o.major == null && this.major == null) {
            return true;
        }
        if (o.major == null) {
            return false;
        }
        if (this.major == null) {
            return false;
        }
        if (Version.valNotMatch((String)o.major, (String)this.major, (VersionMatchType)this.matchType)) {
            return false;
        }
        if (o.minor != null && this.minor != null && Version.valNotMatch((String)o.minor, (String)this.minor, (VersionMatchType)this.matchType)) {
            return false;
        }
        if (o.revision != null && this.revision != null && Version.valNotMatch((String)o.revision, (String)this.revision, (VersionMatchType)this.matchType)) {
            return false;
        }
        return o.ext == null || this.ext == null || Objects.equals(o.ext, this.ext);
    }

    public VersionMatchType getMatchType() {
        return this.matchType;
    }

    public String getMajor() {
        return this.major;
    }

    public String getMinor() {
        return this.minor;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getExt() {
        return this.ext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$major = this.getMajor();
        String other$major = other.getMajor();
        if (this$major == null ? other$major != null : !this$major.equals(other$major)) {
            return false;
        }
        String this$minor = this.getMinor();
        String other$minor = other.getMinor();
        if (this$minor == null ? other$minor != null : !this$minor.equals(other$minor)) {
            return false;
        }
        String this$revision = this.getRevision();
        String other$revision = other.getRevision();
        if (this$revision == null ? other$revision != null : !this$revision.equals(other$revision)) {
            return false;
        }
        String this$ext = this.getExt();
        String other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !this$ext.equals(other$ext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Version;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $major = this.getMajor();
        result = result * 59 + ($major == null ? 43 : $major.hashCode());
        String $minor = this.getMinor();
        result = result * 59 + ($minor == null ? 43 : $minor.hashCode());
        String $revision = this.getRevision();
        result = result * 59 + ($revision == null ? 43 : $revision.hashCode());
        String $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : $ext.hashCode());
        return result;
    }
}

