/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.basic.gateway.polymerization;

import java.net.URI;
import java.util.Objects;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.OrderedGatewayFilter;
import org.springframework.cloud.gateway.filter.factory.RewritePathGatewayFilterFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;

public class RewriteToPolymerizationRewritePathGatewayFilterFactory
extends RewritePathGatewayFilterFactory
implements Ordered {
    private final String serviceId;

    public RewriteToPolymerizationRewritePathGatewayFilterFactory(String serviceId) {
        this.serviceId = "/" + serviceId;
    }

    public GatewayFilter apply(RewritePathGatewayFilterFactory.Config config) {
        String replacement = config.getReplacement().replace("$\\", "$");
        return new OrderedGatewayFilter((exchange, chain) -> {
            ServerHttpRequest req = exchange.getRequest();
            ServerWebExchangeUtils.addOriginalRequestUrl((ServerWebExchange)exchange, (URI)req.getURI());
            String path = req.getURI().getRawPath();
            String newPath = Objects.equals(this.serviceId, path) ? "/" : path.replaceAll(config.getRegexp(), replacement);
            ServerHttpRequest request = req.mutate().path(newPath).build();
            exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, request.getURI());
            return chain.filter(exchange.mutate().request(request).build());
        }, 2);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

