/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.basic.gateway.exception;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.reactive.error.DefaultErrorWebExceptionHandler;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Mono;

class CustomErrorWebExceptionHandler
extends DefaultErrorWebExceptionHandler {
    CustomErrorWebExceptionHandler(ErrorAttributes errorAttributes, ResourceProperties resourceProperties, ErrorProperties errorProperties, ApplicationContext applicationContext) {
        super(errorAttributes, resourceProperties, errorProperties, applicationContext);
    }

    protected Map<String, Object> getErrorAttributes(ServerRequest request, boolean includeStackTrace) {
        Throwable error = super.getError(request);
        HashMap<String, Object> errorAttributes = new HashMap<String, Object>(3);
        errorAttributes.put("status", false);
        errorAttributes.put("message", error.getLocalizedMessage());
        errorAttributes.put("errorCode", 0);
        if (error instanceof ResponseStatusException) {
            ResponseStatusException exception = (ResponseStatusException)error;
            errorAttributes.put("errorCode", 404);
            errorAttributes.put("message", exception.getReason());
        }
        return errorAttributes;
    }

    protected RouterFunction<ServerResponse> getRoutingFunction(ErrorAttributes errorAttributes) {
        return RouterFunctions.route((RequestPredicate)RequestPredicates.all(), arg_0 -> this.renderErrorResponse(arg_0));
    }

    @NonNull
    protected Mono<ServerResponse> renderErrorResponse(ServerRequest request) {
        return super.renderErrorResponse(request);
    }

    protected int getHttpStatus(Map<String, Object> errorAttributes) {
        return HttpStatus.OK.value();
    }
}

