/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.basic.gateway.vc;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionCompareUtils {
    private static final Logger log = LoggerFactory.getLogger(VersionCompareUtils.class);
    private static final String INTERVAL = "\\.";
    private static final String GROUP = ",";
    private static final String LEFT_CONTAIN = "[";
    private static final String RIGHT_CONTAIN = "]";
    private static final String LEFT_NOT_CONTAIN = "(";
    private static final String RIGHT_NOT_CONTAIN = ")";

    private VersionCompareUtils() {
    }

    public static boolean match(String origin, String range) {
        origin = StringUtils.trimToNull((String)origin);
        range = StringUtils.trimToNull((String)range);
        if (origin == null || range == null) {
            return false;
        }
        boolean hasLeftFlag = range.startsWith(LEFT_CONTAIN) || range.startsWith(LEFT_NOT_CONTAIN);
        boolean hasRightFlag = range.endsWith(RIGHT_CONTAIN) || range.endsWith(RIGHT_NOT_CONTAIN);
        boolean hasGroupFlag = range.contains(GROUP);
        boolean noRangeMath = !hasLeftFlag && !hasRightFlag && !hasGroupFlag;
        try {
            if (noRangeMath) {
                return VersionCompareUtils.equalsMatch(origin, range);
            }
            if (hasLeftFlag && hasRightFlag && hasGroupFlag) {
                return VersionCompareUtils.rangeMatch(origin, range);
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean equalsMatch(String origin, String range) {
        String[] originValues = origin.split(INTERVAL);
        String[] rangeValues = range.split(INTERVAL);
        int size = Math.max(originValues.length, rangeValues.length);
        Integer[] origins = VersionCompareUtils.formatVersionString(originValues, size);
        Integer[] ranges = VersionCompareUtils.formatVersionString(rangeValues, size);
        for (int i = 0; i < size; ++i) {
            Integer ov = origins[i];
            Integer rv = ranges[i];
            if (Objects.equals(ov, rv)) continue;
            return false;
        }
        return true;
    }

    private static boolean rangeMatch(String origin, String range) {
        boolean leftContain = range.startsWith(LEFT_CONTAIN);
        boolean rightContain = range.endsWith(RIGHT_CONTAIN);
        range = range.replace(LEFT_CONTAIN, "");
        range = range.replace(LEFT_NOT_CONTAIN, "");
        range = range.replace(RIGHT_CONTAIN, "");
        String[] rangeGroup = (range = range.replace(RIGHT_NOT_CONTAIN, "")).split(GROUP);
        if (rangeGroup.length != 2) {
            return false;
        }
        boolean leftRangeMatchResult = VersionCompareUtils.rangeMatch(origin, StringUtils.trimToEmpty((String)rangeGroup[0]), leftContain, true);
        boolean rightRangeMatchResult = VersionCompareUtils.rangeMatch(origin, StringUtils.trimToEmpty((String)rangeGroup[1]), rightContain, false);
        return leftRangeMatchResult && rightRangeMatchResult;
    }

    private static boolean rangeMatch(String origin, String range, boolean contain, boolean leftMath) {
        String[] originValues = VersionCompareUtils.versionStringFilter(origin).split(INTERVAL);
        String[] rangeValues = VersionCompareUtils.versionStringFilter(range).split(INTERVAL);
        int size = Math.max(originValues.length, rangeValues.length);
        Integer[] origins = VersionCompareUtils.formatVersionString(originValues, size);
        Integer[] ranges = VersionCompareUtils.formatVersionString(rangeValues, size);
        for (int i = 0; i < size; ++i) {
            Integer ov = origins[i];
            Integer rv = ranges[i];
            int compareResult = ov.compareTo(rv);
            if (compareResult < 0) {
                return !leftMath;
            }
            if (compareResult > 0) {
                return leftMath;
            }
            if (i != size - 1) continue;
            return contain;
        }
        return false;
    }

    private static String versionStringFilter(String origin) {
        origin = StringUtils.trimToEmpty((String)origin);
        StringBuilder builder = new StringBuilder();
        int end = origin.length();
        for (int i = 0; i < end; ++i) {
            boolean isPoint;
            char cv = origin.charAt(i);
            boolean isNumber = cv >= '0' && cv <= '9';
            boolean bl = isPoint = cv == '.';
            if (!isNumber && !isPoint) continue;
            builder.append(cv);
        }
        return builder.toString();
    }

    private static Integer[] formatVersionString(String[] values, int length) {
        int i;
        Integer[] result = new Integer[length];
        int end = Math.min(values.length, length);
        for (i = 0; i < end; ++i) {
            result[i] = VersionCompareUtils.stringToInteger(values[i]);
        }
        if (values.length < length) {
            while (i < length) {
                result[i] = 0;
                ++i;
            }
        }
        return result;
    }

    private static Integer stringToInteger(String str) {
        try {
            return Math.max(Integer.parseInt(str), 0);
        }
        catch (Exception ignore) {
            return 0;
        }
    }
}

