/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.basic.gateway.exception;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.reactive.error.DefaultErrorWebExceptionHandler;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Mono;

class CustomErrorWebExceptionHandler
extends DefaultErrorWebExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomErrorWebExceptionHandler.class);

    CustomErrorWebExceptionHandler(ErrorAttributes errorAttributes, WebProperties.Resources resourceProperties, ErrorProperties errorProperties, ApplicationContext applicationContext) {
        super(errorAttributes, resourceProperties, errorProperties, applicationContext);
    }

    protected Map<String, Object> getErrorAttributes(ServerRequest request, ErrorAttributeOptions options) {
        Throwable error = super.getError(request);
        log.debug(error.getLocalizedMessage(), error);
        List stackTrace = Arrays.stream(error.getStackTrace()).map(this::buildStackTraceElementText).collect(Collectors.toList());
        HashMap<String, Object> errorAttributes = new HashMap<String, Object>(3);
        errorAttributes.put("status", false);
        errorAttributes.put("message", error.getLocalizedMessage());
        errorAttributes.put("errorCode", 0);
        errorAttributes.put("stackTrace", stackTrace);
        if (error instanceof ResponseStatusException) {
            ResponseStatusException exception = (ResponseStatusException)error;
            errorAttributes.put("errorCode", exception.getStatus().value());
            errorAttributes.put("message", exception.getReason() != null ? exception.getReason() : exception.getMessage());
        }
        return errorAttributes;
    }

    private String buildStackTraceElementText(StackTraceElement element) {
        return element.getClassName() + element.getMethodName() + ":" + element.getLineNumber();
    }

    protected RouterFunction<ServerResponse> getRoutingFunction(ErrorAttributes errorAttributes) {
        return RouterFunctions.route((RequestPredicate)RequestPredicates.all(), this::renderErrorResponse);
    }

    @NonNull
    protected Mono<ServerResponse> renderErrorResponse(ServerRequest request) {
        return super.renderErrorResponse(request);
    }

    protected int getHttpStatus(Map<String, Object> errorAttributes) {
        return HttpStatus.OK.value();
    }
}

