/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.platform.basic.gateway.vc;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;

/**
 * 版本控制配置
 *
 * @author guer
 */
@Data
@RefreshScope
@ConfigurationProperties(prefix = VersionControlProperties.PROPERTIES_PREFIX)
public class VersionControlProperties {

    /**
     * 配置前缀
     */
    public static final String PROPERTIES_PREFIX = "spring.cloud.gateway.version-control";

    /**
     * 是否启用版本控制
     */
    private boolean enable = false;

    /**
     * 请求头关键字
     */
    private String requestKey = "version";

    /**
     * 服务元信息关键字
     */
    private String metadataKey = "request-version-control";
}
