/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.platform.basic.gateway.vc;

import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.loadbalancer.core.ReactorLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

/**
 * 负载均衡客户端配置
 *
 * @author guer
 */
public class LoadBalancerConfiguration {

    /**
     * 构造服务实例的负载均衡器
     *
     * @param environment
     *         系统环境
     * @param loadBalancerClientFactory
     *         负载均衡客户端工厂类
     * @param versionControlProperties
     *         版本控制配置
     * @return 服务实例的负载均衡器
     */
    @Bean
    public ReactorLoadBalancer<ServiceInstance> loadBalancer(Environment environment,
            LoadBalancerClientFactory loadBalancerClientFactory, VersionControlProperties versionControlProperties) {
        String name = environment.getProperty(LoadBalancerClientFactory.PROPERTY_NAME);
        return new VersionControlReactorServiceInstanceLoadBalancer(
                loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), name,
                versionControlProperties);
    }
}
