/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.platform.basic.gateway.protect;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.http.HttpMethod;

import java.util.List;

/**
 * 接口保护配置
 *
 * @author guer
 */
@Data
@RefreshScope
@ConfigurationProperties(prefix = ProtectProperties.PROPERTIES_PREFIX)
public class ProtectProperties {

    /**
     * 配置前缀
     */
    public static final String PROPERTIES_PREFIX = "spring.cloud.gateway.protect";

    /**
     * 启用标志
     */
    private boolean enable;

    /**
     * 放行请求-请求头名称
     */
    private String releaseHeaderName;

    /**
     * 放行请求-请求头值
     */
    private String releaseHeaderValue;

    /**
     * 待保护路径列表
     */
    private List<Url> urls;

    /**
     * 待保护路径
     */
    @Data
    public static class Url {

        /**
         * 请求方式
         */
        private HttpMethod method;

        /**
         * 路径
         */
        private String path;
    }
}
