/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.basic.gateway.vc;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.guerlab.smart.platform.basic.gateway.vc.VersionCompareUtils;
import net.guerlab.smart.platform.basic.gateway.vc.VersionControlProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.NoopServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.cloud.loadbalancer.core.SelectedInstanceCallback;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Mono;

public class VersionControlReactorServiceInstanceLoadBalancer
implements ReactorServiceInstanceLoadBalancer {
    private static final Logger log = LoggerFactory.getLogger(VersionControlReactorServiceInstanceLoadBalancer.class);
    private final String serviceId;
    private final ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider;
    private final VersionControlProperties versionControlProperties;
    private final AtomicInteger position;

    public VersionControlReactorServiceInstanceLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider, String serviceId, VersionControlProperties versionControlProperties) {
        this.serviceId = serviceId;
        this.serviceInstanceListSupplierProvider = serviceInstanceListSupplierProvider;
        this.versionControlProperties = versionControlProperties;
        this.position = new AtomicInteger(new Random().nextInt(1000));
    }

    public Mono<Response<ServiceInstance>> choose(Request request) {
        Request lbRequest;
        if (!this.versionControlProperties.isEnable()) {
            return this.getDefault(request);
        }
        String requestKey = StringUtils.trimToNull((String)this.versionControlProperties.getRequestKey());
        String metadataKey = StringUtils.trimToNull((String)this.versionControlProperties.getMetadataKey());
        if (requestKey == null || metadataKey == null) {
            return this.getDefault(request);
        }
        try {
            lbRequest = request;
        }
        catch (Exception e) {
            return this.getDefault(request);
        }
        String requestVersion = ((RequestDataContext)lbRequest.getContext()).getClientRequest().getHeaders().getFirst(requestKey);
        if (requestVersion == null) {
            return this.getDefault(request);
        }
        try {
            ServiceInstanceListSupplier supplier = (ServiceInstanceListSupplier)this.serviceInstanceListSupplierProvider.getIfAvailable(NoopServiceInstanceListSupplier::new);
            return supplier.get(request).next().map(serviceInstances -> {
                Response serviceInstanceResponse = this.getInstanceResponseWithRequestVersion(serviceInstances, requestVersion, metadataKey);
                if (supplier instanceof SelectedInstanceCallback && serviceInstanceResponse.hasServer()) {
                    ((SelectedInstanceCallback)supplier).selectedServiceInstance((ServiceInstance)serviceInstanceResponse.getServer());
                }
                return serviceInstanceResponse;
            });
        }
        catch (Exception e) {
            log.debug(e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
    }

    private Response<ServiceInstance> getInstanceResponseWithRequestVersion(List<ServiceInstance> instances, String requestVersion, String metadataKey) {
        if (instances.isEmpty()) {
            log.warn("No servers available for service: {}", (Object)this.serviceId);
            return new EmptyResponse();
        }
        ArrayList hasNotVersions = new ArrayList(instances.size());
        ArrayList equalsVersions = new ArrayList(instances.size());
        ArrayList matchVersions = new ArrayList(instances.size());
        instances.forEach(instance -> {
            String version = (String)instance.getMetadata().get(metadataKey);
            if (version == null) {
                hasNotVersions.add(instance);
            } else if (version.equals(requestVersion)) {
                equalsVersions.add(instance);
            } else if (VersionCompareUtils.match((String)requestVersion, (String)version)) {
                matchVersions.add(instance);
            }
        });
        if (!equalsVersions.isEmpty()) {
            return this.getInstanceResponse(equalsVersions);
        }
        if (!matchVersions.isEmpty()) {
            return this.getInstanceResponse(matchVersions);
        }
        if (!hasNotVersions.isEmpty()) {
            return this.getInstanceResponse(hasNotVersions);
        }
        return new EmptyResponse();
    }

    private Mono<Response<ServiceInstance>> getDefault(Request<?> request) {
        ServiceInstanceListSupplier supplier = (ServiceInstanceListSupplier)this.serviceInstanceListSupplierProvider.getIfAvailable(NoopServiceInstanceListSupplier::new);
        return supplier.get(request).next().map(serviceInstances -> this.processInstanceResponse(supplier, serviceInstances));
    }

    private Response<ServiceInstance> processInstanceResponse(ServiceInstanceListSupplier supplier, List<ServiceInstance> serviceInstances) {
        Response serviceInstanceResponse = this.getInstanceResponse(serviceInstances);
        if (supplier instanceof SelectedInstanceCallback && serviceInstanceResponse.hasServer()) {
            ((SelectedInstanceCallback)supplier).selectedServiceInstance((ServiceInstance)serviceInstanceResponse.getServer());
        }
        return serviceInstanceResponse;
    }

    private Response<ServiceInstance> getInstanceResponse(List<ServiceInstance> instances) {
        if (instances.isEmpty()) {
            log.warn("No servers available for service: " + this.serviceId);
            return new EmptyResponse();
        }
        int pos = Math.abs(this.position.incrementAndGet());
        ServiceInstance instance = instances.get(pos % instances.size());
        return new DefaultResponse(instance);
    }
}

