/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.basic.gateway.protect;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.smart.platform.basic.gateway.protect.ProtectProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ProtectFilter
implements GatewayFilter,
GlobalFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(ProtectFilter.class);
    private final ProtectProperties properties;
    private final AntPathMatcher matcher = new AntPathMatcher();

    public ProtectFilter(ProtectProperties properties) {
        this.properties = properties;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        if (!this.properties.isEnable()) {
            return chain.filter(exchange);
        }
        List urls = this.properties.getUrls();
        if (CollectionUtil.isEmpty((Collection)urls)) {
            return chain.filter(exchange);
        }
        boolean release = false;
        String releaseName = StringUtils.trimToNull((String)this.properties.getReleaseHeaderName());
        String releaseValue = StringUtils.trimToNull((String)this.properties.getReleaseHeaderValue());
        String requestValue = null;
        if (releaseName != null && releaseValue != null) {
            requestValue = exchange.getRequest().getHeaders().getFirst(releaseName);
            release = requestValue != null && Objects.equals(requestValue, releaseValue);
        }
        HttpMethod requestMethod = exchange.getRequest().getMethod();
        String requestPath = exchange.getRequest().getURI().getPath();
        for (ProtectProperties.Url url : urls) {
            HttpMethod method;
            String path = StringUtils.trimToNull((String)url.getPath());
            if (path == null || (method = url.getMethod()) != null && Objects.equals(requestMethod, method) || !this.matcher.match(path, requestPath)) continue;
            log.debug("intercept path info: [url: {}, path: {}]]", (Object)path, (Object)requestPath);
            log.debug("release info: [name: {}, value: {}, request: {}, release: {}]", new Object[]{releaseName, releaseValue, requestValue, release});
            if (release) continue;
            return this.createNotFoundError();
        }
        return chain.filter(exchange);
    }

    private <R> Mono<R> createNotFoundError() {
        return Mono.defer(() -> {
            ResponseStatusException ex = new ResponseStatusException(HttpStatus.NOT_FOUND, "No matching handler");
            return Mono.error((Throwable)ex);
        });
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

