/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.basic.gateway.logger;

import net.guerlab.smart.platform.basic.gateway.logger.LoggerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Order(value=-2147483648)
public class RequestTimeFilter
implements GlobalFilter {
    private static final Logger log = LoggerFactory.getLogger(RequestTimeFilter.class);
    private static final String REQUEST_TIME = "requestTimeStartWith";
    private final LoggerProperties properties;

    public RequestTimeFilter(LoggerProperties properties) {
        this.properties = properties;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        if (!this.properties.isEnableRecordRequestTime()) {
            return chain.filter(exchange);
        }
        exchange.getAttributes().put(REQUEST_TIME, System.currentTimeMillis());
        return chain.filter(exchange).then(Mono.fromCallable(() -> {
            Long startTime = (Long)exchange.getAttribute(REQUEST_TIME);
            if (startTime != null) {
                log.info("request [{}]:[{}] used: {} milliseconds", new Object[]{exchange.getRequest().getMethod(), exchange.getRequest().getPath(), System.currentTimeMillis() - startTime});
            }
            return null;
        }));
    }
}

