/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.web.wx;

import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import net.guerlab.smart.pay.core.domain.PayLogExtends;
import net.guerlab.smart.pay.service.entity.PayLog;
import net.guerlab.smart.pay.service.service.PayLogService;
import net.guerlab.smart.pay.web.wx.AbstractWxPayController;
import net.guerlab.smart.pay.web.wx.WxPayServiceConstant;
import net.guerlab.smart.platform.commons.ip.IpUtils;
import net.guerlab.smart.wx.auth.WxUserContextHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

public abstract class AbstractWxPayRequestController
extends AbstractWxPayController {
    private static final Logger log = LoggerFactory.getLogger(AbstractWxPayRequestController.class);
    private PayLogService logService;

    @Operation(description="\u901a\u8fc7\u652f\u4ed8\u8ba2\u5355ID\u8bf7\u6c42\u652f\u4ed8", security={@SecurityRequirement(name="Authorization")})
    @GetMapping(value={"/byPayOrderId/{appId}/{payOrderId}"})
    public final Object byPayOrderId(@Parameter(name="\u5fae\u4fe1\u5e94\u7528ID", required=true) @PathVariable String appId, @Parameter(name="\u652f\u4ed8\u8ba2\u5355ID", required=true) @PathVariable Long payOrderId, HttpServletRequest request) {
        PayLog payLog = this.logService.create(payOrderId, this.getPayChannel(), this.createPayLogExtends(appId));
        return this.pay0(WxUserContextHandler.getOpenId(), appId, payLog, request);
    }

    @Operation(description="\u901a\u8fc7\u4e1a\u52a1\u5206\u7ec4\u548c\u4e1a\u52a1ID\u8bf7\u6c42\u652f\u4ed8", security={@SecurityRequirement(name="Authorization")})
    @GetMapping(value={"/byBusinessId/{appId}/{businessGroup}/{businessId}"})
    public final Object byBusinessId(@Parameter(name="\u5fae\u4fe1\u5e94\u7528ID", required=true) @PathVariable String appId, @Parameter(name="\u4e1a\u52a1\u5206\u7ec4", required=true) @PathVariable String businessGroup, @Parameter(name="\u4e1a\u52a1ID", required=true) @PathVariable String businessId, HttpServletRequest request) {
        PayLog payLog = this.logService.create(businessGroup, businessId, this.getPayChannel(), this.createPayLogExtends(appId));
        return this.pay0(WxUserContextHandler.getOpenId(), appId, payLog, request);
    }

    private PayLogExtends createPayLogExtends(String appId) {
        PayLogExtends payLogExtends = new PayLogExtends();
        payLogExtends.put((Object)"appId", (Object)appId);
        return payLogExtends;
    }

    private <T> T pay0(String openId, String appId, PayLog payLog, HttpServletRequest request) {
        String payLogIdString = Objects.toString(payLog.getPayLogId());
        WxPayUnifiedOrderRequest orderRequest = new WxPayUnifiedOrderRequest();
        orderRequest.setOpenid(openId);
        orderRequest.setProductId(payLogIdString);
        orderRequest.setBody(payLog.getOrderTitle());
        orderRequest.setOutTradeNo(payLogIdString);
        orderRequest.setTotalFee(Integer.valueOf(payLog.getAmount().multiply(WxPayServiceConstant.HUNDRED).intValue()));
        orderRequest.setSpbillCreateIp(IpUtils.getIp((HttpServletRequest)request));
        orderRequest.setTimeExpire(payLog.getPayTimeoutTime().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        orderRequest.setNotifyUrl(this.getNotifyUrl(appId));
        orderRequest.setTradeType(this.getWxPayServiceType().getTradeType());
        return this.buildWxPayService(appId, true).createOrder(orderRequest);
    }

    protected abstract String getNotifyUrl(String var1);

    @Autowired
    public void setLogService(PayLogService logService) {
        this.logService = logService;
    }
}

