/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.web.wx;

import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.pay.core.enums.PayStatus;
import net.guerlab.smart.pay.service.entity.PayLog;
import net.guerlab.smart.pay.service.entity.PayLogNotify;
import net.guerlab.smart.pay.service.service.NotifyOriginalLogService;
import net.guerlab.smart.pay.service.service.PayLogNotifyService;
import net.guerlab.smart.pay.service.service.PayLogService;
import net.guerlab.smart.pay.web.wx.AbstractWxPayController;
import net.guerlab.smart.pay.web.wx.WxPayServiceConstant;
import net.guerlab.spring.web.annotation.IgnoreResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class AbstractWxPayNotifyController
extends AbstractWxPayController {
    private static final Logger log = LoggerFactory.getLogger(AbstractWxPayNotifyController.class);
    private PayLogService logService;
    private PayLogNotifyService notifyService;
    private NotifyOriginalLogService notifyOriginalLogService;

    @Operation(description="\u56de\u8c03\u901a\u77e5")
    @PostMapping(value={"/{appId}"})
    @IgnoreResponseHandler
    public final String notify(@Parameter(name="\u5fae\u4fe1\u5e94\u7528ID", required=true) @PathVariable String appId, @RequestBody String xmlData) {
        String result = this.notify0(appId, xmlData);
        this.notifyOriginalLogService.add(this.getPayChannel(), (Object)xmlData, result);
        return result;
    }

    protected final String notify0(String appId, String xmlData) {
        long payLogId;
        WxPayOrderNotifyResult notifyResult;
        try {
            notifyResult = this.buildWxPayService(appId).parseOrderNotifyResult(xmlData);
        }
        catch (ApplicationException e) {
            return WxPayNotifyResponse.fail((String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            return WxPayNotifyResponse.fail((String)"build WxPayService faild");
        }
        try {
            payLogId = Long.parseLong(notifyResult.getOutTradeNo());
        }
        catch (Exception e) {
            return WxPayNotifyResponse.fail((String)e.getLocalizedMessage());
        }
        BigDecimal amount = new BigDecimal(notifyResult.getTotalFee()).divide(WxPayServiceConstant.HUNDRED, 2, RoundingMode.FLOOR);
        String notifyAppId = notifyResult.getAppid();
        if (!Objects.equals(appId, notifyAppId)) {
            return WxPayNotifyResponse.fail((String)"appId not equals");
        }
        PayLog payLog = (PayLog)this.logService.selectById((Serializable)Long.valueOf(payLogId));
        if (payLog == null) {
            return WxPayNotifyResponse.fail((String)"payLog invalid");
        }
        if (!Objects.equals(this.getPayChannel(), payLog.getPayChannel())) {
            return WxPayNotifyResponse.fail((String)("payLog payChannel error, need: " + payLog.getPayChannel() + ", input: " + this.getPayChannel()));
        }
        if (!NumberHelper.isEquals((Comparable)amount, (Comparable)payLog.getAmount())) {
            return WxPayNotifyResponse.fail((String)("payLog amount error, need: " + payLog.getAmount() + ", input: " + amount));
        }
        if (!Objects.equals(appId, payLog.getExtend().get((Object)"appId"))) {
            return WxPayNotifyResponse.fail((String)("payLog appId error, need: " + payLog.getExtend() + ", input: " + appId));
        }
        if (payLog.getPayStatus() != PayStatus.WAIT_PAY) {
            return WxPayNotifyResponse.fail((String)("payLog status error: " + payLog.getPayStatus()));
        }
        PayLogNotify payLogNotify = PayLogNotify.buildByPayLog((PayLog)payLog);
        payLogNotify.setOutOrderSn(notifyResult.getTransactionId());
        try {
            this.notifyService.insert((Object)payLogNotify);
        }
        catch (Exception e) {
            log.debug(e.getLocalizedMessage(), (Throwable)e);
        }
        this.logService.payed(payLog);
        return WxPayNotifyResponse.success((String)"OK");
    }

    @Autowired
    public void setLogService(PayLogService logService) {
        this.logService = logService;
    }

    @Autowired
    public void setNotifyService(PayLogNotifyService notifyService) {
        this.notifyService = notifyService;
    }

    @Autowired
    public void setNotifyOriginalLogService(NotifyOriginalLogService notifyOriginalLogService) {
        this.notifyOriginalLogService = notifyOriginalLogService;
    }
}

