/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.web.excel;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import net.guerlab.smart.pay.core.enums.PayStatus;

public class PayStatusConverter
implements Converter<PayStatus> {
    public Class supportJavaTypeKey() {
        return PayStatus.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public PayStatus convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        switch (cellData.getStringValue()) {
            case "\u5f85\u652f\u4ed8": {
                return PayStatus.WAIT_PAY;
            }
            case "\u5df2\u5b8c\u6210": {
                return PayStatus.PAYED;
            }
            case "\u5df2\u8d85\u65f6": {
                return PayStatus.TIMEOUT;
            }
            case "\u5df2\u53d6\u6d88": {
                return PayStatus.CANCELED;
            }
        }
        return null;
    }

    public CellData convertToExcelData(PayStatus value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        switch (value) {
            case WAIT_PAY: {
                return new CellData("\u5f85\u652f\u4ed8");
            }
            case PAYED: {
                return new CellData("\u5df2\u5b8c\u6210");
            }
            case TIMEOUT: {
                return new CellData("\u5df2\u8d85\u65f6");
            }
            case CANCELED: {
                return new CellData("\u5df2\u53d6\u6d88");
            }
        }
        return null;
    }
}

