/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.web.controller.commons.pay.alipay;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.servlet.http.HttpServletRequest;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.pay.service.entity.PayLog;
import net.guerlab.smart.pay.web.alipay.AbstractAlipayRequestController;
import net.guerlab.smart.pay.web.alipay.AlipayTradeType;
import net.guerlab.web.result.Succeed;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u652f\u4ed8\u8bf7\u6c42-\u652f\u4ed8\u5b9d-wap")
@RestController(value="/commons/pay/alipay/wap")
@RequestMapping(value={"/commons/pay/alipay/wap"})
public class AlipayWapPayController
extends AbstractAlipayRequestController {
    public static final String URL = "/commons/pay/alipay/wap";

    @Override
    protected Object pay0(String appId, PayLog payLog, String returnUrl, HttpServletRequest request) {
        AlipayTradeWapPayModel bizModel = new AlipayTradeWapPayModel();
        bizModel.setOutTradeNo(String.valueOf(payLog.getPayLogId()));
        bizModel.setProductCode("QUICK_WAP_WAY");
        bizModel.setTotalAmount(payLog.getAmount().toString());
        bizModel.setSubject(payLog.getOrderTitle());
        AlipayTradeWapPayRequest payRequest = new AlipayTradeWapPayRequest();
        this.fillRequestData(appId, returnUrl, (AlipayRequest<?>)payRequest, (AlipayObject)bizModel);
        try {
            return new Succeed("success", (Object)((AlipayTradeWapPayResponse)this.buildAlipayClient(appId, true).pageExecute((AlipayRequest)payRequest)).getBody());
        }
        catch (AlipayApiException e) {
            throw new ApplicationException(e.getErrCode() + ":" + e.getErrMsg());
        }
    }

    @Override
    protected String getNotifyUrl(String appId) {
        return "/commons/notify/alipay/wap/" + appId;
    }

    @Override
    protected AlipayTradeType getAlipayTradeType() {
        return AlipayTradeType.WAP;
    }
}

